<?php
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error_log.txt');

// تعريف مسار ملف إعداد الجلسة
$tool = $_GET['tool'] ?? '';
$redirect = false;

// التحقق من اسم الأداة
if ($tool !== 'keywordrevealer') {
    error_log("Invalid tool specified.");
    $redirect = true;
}

// التحقق من وجود ملف الإعدادات
if (!$redirect) {
    $configFile = __DIR__ . "/keywordrevealer.php";
    if (!file_exists($configFile)) {
        error_log("Configuration file not found.");
        $redirect = true;
    }
}

// استخراج الرابط وبيانات الكوكيز من ملف الإعداد
if (!$redirect) {
    $fileContent = file_get_contents($configFile);

    if (preg_match('/<span[^>]+href="([^"]+)"[^>]*>(.*?)<\/span>/is', $fileContent, $matches)) {
        $targetUrl = $matches[1];
        $jsonCookies = trim($matches[2]);
    } else {
        error_log("Invalid configuration format.");
        $redirect = true;
    }
}

// فك ترميز بيانات الكوكيز من JSON
if (!$redirect && $jsonCookies) {
    $cookiesArray = json_decode($jsonCookies, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Failed to decode JSON cookies.");
        $redirect = true;
    }
}

// تحضير الكوكيز لـ cURL
$cookieString = '';
if (!$redirect && isset($cookiesArray)) {
    foreach ($cookiesArray as $cookie) {
        if (isset($cookie['name']) && isset($cookie['value'])) {
            $cookieString .= "{$cookie['name']}={$cookie['value']}; ";
        }
    }
}

// تهيئة cURL للتحقق من صلاحية الجلسة
if (!$redirect) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $targetUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIE, $cookieString);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);

    curl_close($ch);

    // طباعة الرابط النهائي لفحصه في السجل
    error_log("Final URL: " . $finalUrl);

    // التحقق إذا كانت الاستجابة تحتوي على كلمات معينة مثل login أو signin
    if (preg_match('/(login|signin|new-rewrite)/i', $finalUrl)) {
        error_log("Session invalid or unauthorized redirection detected.");
        $redirect = true;
    }
}

// توجيه المستخدم بناءً على نتيجة التحقق النهائي
if ($redirect) {
    header("Location: https://keywordrevealer.com/");
    exit;
} else {
    header("Location: https://session.digitalbangla.pro/keywordrevealer/keywordrevealer.php");
    exit;
}
?>
